package route

import (
	"github.com/gin-contrib/sessions"
	"github.com/gin-contrib/sessions/cookie"
	"github.com/gin-gonic/gin"
	"goweb/common/logger"
	"goweb/common/middleware"
)

func WebRun() *gin.Engine {
	// 创建路由
	r := gin.Default()

	r.Delims("{[", "]}")
	//初始化日志配置参数
	logger.Init("", "./logs/app.log", 0, 0, 0)
	//注册日志记录中间件
	r.Use(logger.GinLogger(), logger.GinRecovery(true))

	// 创建基于cookie的存储引擎，参数是用于加密的密钥
	store := cookie.NewStore([]byte("gogogowebweb123mysession"))
	// 设置session中间件，参数mysession，指的是session的名字，也是cookie的名字
	// store是前面创建的存储引擎，我们可以替换成其他存储引擎
	r.Use(sessions.Sessions("mysession", store))
	r.Use(middleware.Cors())
	//注册前台路由组
	r = IndexRouter(r)
	//注册后台路由组
	r = AdminRouter(r)

	//定义静态资源路由
	r.Static("/static", "./static")
	//404文件
	r.NoRoute(func(c *gin.Context) {
		r.LoadHTMLGlob("app/error/views/**/*")
		c.HTML(404, "error/404.html", gin.H{
			"title": "页面404了",
		})
	})

	return r
}
