package route

import (
	"github.com/gin-gonic/gin"
	index "goweb/app/index/controller"
)

//前台路由组
func IndexRouter(r *gin.Engine) *gin.Engine {
	//调用控制器结构体
	Index := &index.IndexController{}

	//注册路由
	r.GET("/", Index.Index)
	AppIndex := r.Group("/", func(ctx *gin.Context) {
		//定义模板文件路径
		r.LoadHTMLGlob("app/index/views/**/*")
	})
	{
		//定义后台模板文件路径
		//r.LoadHTMLGlob("app/index/views/**/*")
		r.GET("/index", Index.Index)
		//注册index应用下的路由
		IndexController := AppIndex.Group("/index")
		{
			IndexController.GET("/index", Index.Index)
		}
	}
	return r
}
