package route

import (
	"github.com/gin-gonic/gin"
	admin "goweb/app/admin/controller"
	"goweb/app/admin/middleware"
)

//后台路由组
func AdminRouter(r *gin.Engine) *gin.Engine {

	//调用控制器结构体
	loginC := &admin.LoginController{}
	indexC := &admin.IndexController{}

	//注册后台路由
	AppAdmin := r.Group("/admin", middleware.AuthorityVerification(), func(ctx *gin.Context) {
		//定义模板文件路径
		r.LoadHTMLGlob("app/admin/views/**/*")
	})
	{
		IndexController := AppAdmin.Group("/index")
		{
			IndexController.GET("/index", indexC.Index)
			IndexController.GET("/console", indexC.Console)
		}
		AdminController := AppAdmin.Group("/login")
		{
			AdminController.GET("/index", loginC.Index)
			AdminController.POST("/login", loginC.Login)
		}
	}
	return r
}
