package controller

import (
	"fmt"
	"github.com/gin-contrib/sessions"
	"github.com/gin-gonic/gin"
	"goweb/app"
	"net/http"
)

type IndexController struct {
	app.BaseController
}

type User struct {
	Name string `json:"name" form:"name"`
	Age  int    `json:"age" form:"age"`
}

func (this *IndexController) Index(ctx *gin.Context) {
	user := User{}
	err := ctx.ShouldBind(&user)
	//判断参数校验是否通过，如果不通过，把错误返回给前端
	if err != nil {
		this.ErrorJson(ctx, 200, "请求参数错误!", "", 200)
		return
	}
	// 初始化session对象
	session := sessions.Default(ctx)
	if session.Get("name") == "李四" {
		fmt.Println(session.Get("name"))
	} else {
		session.Set("name", "李四")
	}
	session.Save()
	//usermodel := model.User{
	//	Name:     user.Name,
	//	Username: "sdad",
	//	Age:      user.Age,
	//	Email:    "123@qq.com",
	//}
	//db := common.Db
	//db.Create(&usermodel)
	// 记录日志并使用zap.Xxx(key, val)记录相关字段
	//logger.Debug("this is hello func")
	//视图渲染
	ctx.HTML(http.StatusOK, "index/index.html", gin.H{
		"name": "前台",
	})
	//返回json
	//this.SuccessJson(ctx, "变量获取成功", user)
}
