package app

import (
	"github.com/gin-gonic/gin"
)

type BaseController struct {
	//Ctx *gin.Context
}

//定义json返回结构体
type ReturnMsg struct {
	Code int         `json:"code"`
	Msg  string      `json:"msg"`
	Data interface{} `json:"data"`
}

//成功的json返回方法
func (this *BaseController) SuccessJson(ctx *gin.Context, msg string, data interface{}) {
	if data == nil {
		data = gin.H{}
	}
	res := ReturnMsg{
		200, msg, data,
	}
	//返回json
	ctx.JSON(200, res)
}

//失败的json返回方法
func (this *BaseController) ErrorJson(ctx *gin.Context, code int, msg string, data interface{}, httpCode int) {
	if httpCode == 0 {
		httpCode = 200
	}
	if data == nil {
		data = gin.H{}
	}
	res := ReturnMsg{
		code, msg, data,
	}
	//返回json
	ctx.JSON(httpCode, res)
}
