<?php
namespace app\worker;

use GatewayWorker\Lib\Gateway;
use think\facade\Session;

class WorkerE
{
    // 当有客户端连接时，将client_id返回，让mvc框架判断当前uid并执行绑定
    public static function onConnect($client_id)
    {
        Gateway::sendToClient($client_id, json_encode(array(
            'type'      => 'init',
            'client_id' => $client_id
        )));
    }

    /**
     * onMessage 事件回调
     * 当客户端发来数据(Gateway进程收到数据)后触发
     *
     * @access public
     * @param  int       $client_id
     * @param  mixed     $data
     * @return void
     */
    public static function onMessage($client_id, $data)
    {
        Session::set('name',$data);
        GateWay::sendToAll(json_encode(['type'=>'dl','msg' => Session::get('name').' 登陆! 当前在线人数:'.Gateway::getAllClientIdCount().'人']));
    }

    /**
     * onClose 事件回调 当用户断开连接时触发的方法
     *
     * @param  integer $client_id 断开连接的客户端client_id
     * @return void
     */
    public static function onClose($client_id)
    {
        GateWay::sendToAll(json_encode(['type'=>'tc','msg' => Session::get('name').' 退出! 当前在线人数:'.Gateway::getAllClientIdCount().'人']));
    }


}
