<?php
namespace app\index\controller;
use think\Controller;
use GatewayWorker\Lib\Gateway;
use think\facade\Request;
use think\facade\Session;

class Index extends Controller
{
    public function index()
    {
        if(Session::has('name')){
            return $this->fetch();
        }else{
            return $this->fetch('login');
        }
        
    }
    //登陆
    public function login(){
        if(Request::isPost()){
            $name = Request::instance()->param('name');
            Session::set('name',$name);
            $this->success('登陆成功', 'index/index');
        }else{
            return $this->fetch('login');
        }
    }
    //收到消息
    public function isn(){
        $data = Request::post();
        Gateway::$registerAddress = '127.0.0.1:1236';
        GateWay::sendToAll(json_encode(['type'=>'fxx','user'=>$data['name'],'msg' => $data['content']]));
        dump($data);
    }

    public function bind(){
        $client_id = Request::post('client_id');
        Session::set('client_id',$client_id);
        Gateway::$registerAddress = '127.0.0.1:1236';
        // 假设用户已经登录，用户uid和群组id在session中
        $uid = Session::get('name');
        // client_id与uid绑定
        Gateway::bindUid($client_id, $uid);
        return $uid;
    }
    
    public function tc(){
        Session::clear();
        $this->success('退出成功', 'index/index');
    }

}
